/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.fakeinventories;

import cn.nukkit.Player;
import cn.nukkit.event.EventHandler;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.event.inventory.InventoryTransactionEvent;
import cn.nukkit.event.server.DataPacketSendEvent;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.SlotChangeAction;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.UpdateBlockPacket;
import com.nukkitx.fakeinventories.inventory.FakeInventories;
import com.nukkitx.fakeinventories.inventory.FakeInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FakeInventoriesListener
implements Listener {
    private final FakeInventories fakeInventories;

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPacketSend(DataPacketSendEvent event) {
        DataPacket packet = event.getPacket();
        if (packet instanceof UpdateBlockPacket) {
            UpdateBlockPacket updateBlock = (UpdateBlockPacket)packet;
            List<BlockVector3> positions = this.fakeInventories.getFakeInventoryPositions(event.getPlayer());
            if (positions != null) {
                for (BlockVector3 pos : positions) {
                    if (pos.x != updateBlock.x || pos.y != updateBlock.y || pos.z != updateBlock.z) continue;
                    event.setCancelled();
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTransaction(InventoryTransactionEvent event) {
        HashMap<FakeInventory, List> actions = new HashMap<FakeInventory, List>();
        Player source = event.getTransaction().getSource();
        long creationTime = event.getTransaction().getCreationTime();
        for (InventoryAction action : event.getTransaction().getActions()) {
            SlotChangeAction slotChange;
            if (!(action instanceof SlotChangeAction) || !((slotChange = (SlotChangeAction)action).getInventory() instanceof FakeInventory)) continue;
            FakeInventory inventory = (FakeInventory)slotChange.getInventory();
            List slotChanges = actions.computeIfAbsent(inventory, fakeInventory -> new ArrayList());
            slotChanges.add(slotChange);
        }
        boolean cancel = false;
        for (Map.Entry entry : actions.entrySet()) {
            for (SlotChangeAction action : (List)entry.getValue()) {
                if (!((FakeInventory)((Object)entry.getKey())).onSlotChange(source, action)) continue;
                cancel = true;
            }
        }
        if (cancel) {
            event.setCancelled();
        }
    }

    public FakeInventoriesListener(FakeInventories fakeInventories) {
        this.fakeInventories = fakeInventories;
    }
}

